//
//  WXKWindowController.h
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/23.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "FJDIndexedItemsWindowController.h"


extern NSString *WXKToolbarReceiveItemIdentifier;			// receive: (defined in this method)
extern NSString *WXKToolbarSendItemIdentifier;				// send: (defined in this method)
extern NSString *WXKToolbarAddressUtilityItemIdentifier;	// launchAddressUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarBookmarkUtilityItemIdentifier;	// launchBookmarkUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarFileUtilityItemIdentifier;		// launchFileUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarMailUtilityItemIdentifier;		// launchMailUtility: (defined in WXKAppDelegate)


@interface WXKWindowController : FJDIndexedItemsWindowController
{

}

#pragma mark Class methods
+ (NSString *)metadataDirectory;

#pragma mark Action methods
- (IBAction)send:(id)sender;
- (IBAction)receive:(id)sender;

#pragma mark NSErrorRecoveryAttempting informal protocol
- (void)attemptRecoveryFromError:(NSError *)error optionIndex:(unsigned int)recoveryOptionIndex delegate:(id)delegate didRecoverSelector:(SEL)didRecoverSelector contextInfo:(void *)contextInfo;

@end


// Methods defined below are invoked in send: and receive:, respectively.
// Subclasss should implement these methods.

@interface WXKWindowController (Communicating)

- (BOOL)receiveWithPassword:(NSString *)password error:(NSError **)error;
- (BOOL)sendWithPassword:(NSString *)password error:(NSError **)error;

@end
